package com.ejie.ab04b.dao;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.TareaOS3;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TareaOS3Dao generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

public interface TareaOS3Dao {

	/**
	 * Inserts a single row in the TareaOS3 table.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  TareaOS3
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @return the tarea OS 3
	 */
	TareaOS3 add(TareaOS3 tareaOS3);

	/**
	 * Updates a single row in the TareaOS3 table.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  TareaOS3
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @return the tarea OS 3
	 */
	TareaOS3 update(TareaOS3 tareaOS3);

	/**
	 * Updates a single row in the Expedientes table.
	 * 
	 *  tarea
	 *            TareaOS3
	 *  TareaOS3
	 *
	 * @param tarea the tarea
	 * @return the tarea OS 3
	 */
	public TareaOS3 updateFilled(TareaOS3 tarea);

	/**
	 * Finds a single row in the TareaOS3 table.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  TareaOS3
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @return the tarea OS 3
	 */
	TareaOS3 find(TareaOS3 tareaOS3);

	/**
	 * Finds a single row in the TareaOS3 table.
	 * 
	 *  mailboxTaskId the mailbox task id
	 *  TareaOS3
	 *
	 * @param mailboxTaskId the mailbox task id
	 * @return the tarea OS 3
	 */
	@Transactional(readOnly = true)
	public TareaOS3 findByMailboxTaskId(String mailboxTaskId);

	/**
	 * Removes a single row in the TareaOS3 table.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *
	 * @param tareaOS3 the tarea OS 3
	 */
	void remove(TareaOS3 tareaOS3);

	/**
	 * Finds a List of rows in the TareaOS3 table.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<TareaOS3> findAll(TareaOS3 tareaOS3,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the TareaOS3 table using like.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TareaOS3> findAllLike(TareaOS3 tareaOS3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the TareaOS3 table using like.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @param startsWith the starts with
	 * @return the long
	 */
	Long findAllLikeCount(TareaOS3 tareaOS3, Boolean startsWith);

	/**
	 * Counts rows in the TareaOS3 table.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  Long
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @return the long
	 */
	Long findAllCount(TareaOS3 tareaOS3);

	/**
	 * Reorder selection.
	 * 
	 *  filterTareaOS3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<TareaOS3>>
	 *
	 * @param filterTareaOS3 the filter tarea OS 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<TareaOS3>> reorderSelection(TareaOS3 filterTareaOS3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 * 
	 *  filterTareaOS3
	 *            TareaOS3
	 *  searchTareaOS3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<TareaOS3>>
	 *
	 * @param filterTareaOS3 the filter tarea OS 3
	 * @param searchTareaOS3 the search tarea OS 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<TareaOS3>> search(TareaOS3 filterTareaOS3,
			TareaOS3 searchTareaOS3, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

}
